/*
 * Projet Cryptolib CPS3 ASIP:
 *
 * Ensemble de fonctions utilitaires et interfaces avec la couche java du programme d'exemple
 *
*/
#ifndef javautil_h
#define javautil_h

#include <jni.h>
#include <assert.h>
#include <pkcs11.h>

/* Niveaux de log */
#define LOG_DEBUG 1
#define LOG_INFO 2
#define LOG_WARN 3
#define LOG_ERROR 4

/* Classes d'exceptions utilises */
#define CLASS_EXCEPTION "java/lang/Exception"
#define CLASS_PKCS11EXCEPTION "iaik/pkcs/pkcs11/wrapper/PKCS11Exception"
#define CLASS_PKCS11RUNTIMEEXCEPTION "iaik/pkcs/pkcs11/wrapper/PKCS11RuntimeException"

/* Macro de conversion d'un ulong en jlong */
#define ckULongToJLong(x) (jlong) x
/* Macro de conversion d'un const unsigned char en jchar */
#define cUnsignedCharToJChar(x) ((jchar) x)
/* Macro de conversion d'un CK_BYTE en jbyte */
#define ckByteToJByte(x) (jbyte) x
/* Macro de conversion d'un jbyte en CK_BYTE  */
#define jByteToCKByte(x) (CK_BYTE) x
/* Macro de conversion d'un CK_ULONG en jsize */
#define ckULongToJSize(x) (jsize) x
/* Macro de conversion d'un jint en CK_ULONG */
#define jIntToCKULong(x) (CK_ULONG) x

/* Fonctions de gestion d'exceptions */
void throwException(JNIEnv *, const char *);
void throwPKCS11Exception(JNIEnv *, CK_RV);
void testCodeRetourOK(JNIEnv *, CK_RV);

/* Fonction qui logue un message au niveau java */
void log(JNIEnv *, jobject, int, jstring);

/* Fonctions d'interaction avec l'utilisateur */
jint demandeConnexionLecteur(JNIEnv *, jobject);
jint demandeInsertionCarte(JNIEnv *, jobject);
jint demandeChoixNbEssaisPossiblesAvantBlocageCodePorteur(JNIEnv* , jobject);
jint demandeSaisieCodePorteur(JNIEnv *, jobject, CK_FLAGS, CK_FLAGS, char**, unsigned char[16]);
jint demandeRecyclageCodePorteur(JNIEnv *, jobject, CK_FLAGS, CK_FLAGS, CK_FLAGS, char**, char**, char**, unsigned char[16]);
jint demandeDemarrageAttenteEvenementSlot(JNIEnv *, jobject, int, unsigned char[16]);
void alerteCarteRetrouvee(JNIEnv *, jobject);
jint demandeActionSurLecteurCarte(JNIEnv *, jobject, int, unsigned char[16]);
jint demandeSaisieModificationObjet(JNIEnv *, jobject, CK_BYTE_PTR, CK_ULONG, CK_BYTE_PTR *, CK_ULONG_PTR);

/* Fonction de conversion d'un jchararray en char* */
char* jCharArrayToCharPtr(JNIEnv *, jcharArray);

/* Fonction de conversion d'un const char* en jstring  */
jstring cCharPtrTojstring(JNIEnv *, const char *);

/* Fonction d'extraction d'un int depuis un objet */
jint extraitInt(JNIEnv *, jobject);

/* Fonction de conversion d'un const unsigned char[] and its length to a jcharArray */
jcharArray cUnsignedCharToJCharArray(JNIEnv *, const unsigned char[], int);

/* Convertit un tableau de CK_BYTE et sa longueur en jbyteArray */
jbyteArray ckByteArrayToJByteArray(JNIEnv *, const CK_BYTE_PTR, CK_ULONG);

/* Convertit un jbyteArray en tableau de CK_BYTE. La mmoire alloue doit tre libre aprs utilisation */
void jByteArrayToCKByteArray(JNIEnv *, const jbyteArray , CK_BYTE_PTR *, CK_ULONG_PTR);

#endif
